package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectTruckWaitSqlProvider {

    public String pageWaitReport(@Param("page") Page<CollectTruckWaitVO> page, @Param("param") PageCollectTruckWaitParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, truck_no as truckNo, child_no as childNo, address_id as addressId, " +
                    " address, report_type as reportType, wait_type as waitType, station_in_time as stationInTime, " +
                    " station_in_image as stationInImage, station_out_time as stationOutTime, station_out_image as stationOutImage, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " audit_status, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM(" collect_truck_wait ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("report_time desc");
        }}.toString();
    }
    public String carrierPageWaitReport(@Param("page") Page<CollectTruckWaitVO> page, @Param("param") CarrierPageCollectTruckWaitParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, truck_no as truckNo, child_no as childNo, address_id as addressId, " +
                    " address, report_type as reportType, wait_type as waitType, station_in_time as stationInTime, " +
                    " station_in_image as stationInImage, station_out_time as stationOutTime, station_out_image as stationOutImage, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " audit_status, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM(" collect_truck_wait ");

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getAddress())) {WHERE("address like CONCAT(#{param.address},'%')");}
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no like CONCAT('%', #{param.truckNo}, '%')");}
            if (param.getReportType() != null) {WHERE("report_type = #{param.reportType}");}
            if (param.getWaitType() != null) {WHERE("wait_type = #{param.waitType}");}
            if (param.getAuditStatus() != null) {WHERE("audit_status = #{param.auditStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

}
