package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam;
import com.clx.performance.vo.pc.collect.CollectTruckLocationVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectTruckLocationSqlProvider {

    public String pageLocation(@Param("page") Page<CollectTruckLocationVO> page, @Param("param") PageCollectTruckLocationParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, " +
                    " province, city, county, town, street, address, full_address, longitude, latitude, " +
                    " truck_order_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    "date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_location ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageLocation(@Param("page") Page<CollectTruckLocationVO> page, @Param("param") CarrierPageCollectTruckLocationParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, " +
                    " province, city, county, town, street, address, full_address, longitude, latitude, " +
                    " truck_order_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    "date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_location ");
            if (StringUtils.isNotBlank(param.getAddress())) {WHERE("full_address like CONCAT(#{param.address},'%')");}

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}
            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no like CONCAT('%', #{param.truckNo}, '%')");}

            if (param.getTruckOrderStatus() != null) {WHERE("truck_order_status = #{param.truckOrderStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }



}
