package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.collect.CollectDriverTransportIntentionService;
import com.clx.performance.vo.pc.collect.CarrierDriverCollectTransportIntentionRecordVO;
import com.clx.performance.vo.pc.collect.CarrierDriverCollectTransportIntentionVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value = "/pc/carrier/driver/collect/intention")
@Validated
@Tag(name = "承运PC-配置中心—配置管理—问卷配置")
@AllArgsConstructor
public class CarrierDriverCollectTransportIntentionController {
    private final CollectDriverTransportIntentionService collectDriverTransportIntentionService;

    @Operation(summary = "新增", description = "<br>By:马路路")
    @PostMapping("/add")
    public Result<Object> saveCarrierDriverCollectTransportIntention(@RequestBody @Validated CarrierDriverCollectTransportIntentionAddParam param) {
        collectDriverTransportIntentionService.saveCarrierDriverCollectTransportIntention(param);
        return Result.ok();
    }

    @Operation(summary = "编辑更新", description = "<br>By:马路路")
    @PostMapping("/update")
    public Result<Object> updateCarrierDriverCollectTransportIntention(@RequestBody @Validated CarrierDriverCollectTransportIntentionEditParam param) {
        collectDriverTransportIntentionService.updateCarrierDriverCollectTransportIntention(param);
        return Result.ok();
    }

    @Operation(summary = "删除", description = "<br>By:马路路")
    @PostMapping("/delete")
    public Result<Object> deleteCarrierDriverCollectTransportIntention(@RequestBody CarrierDriverCollectTransportIntentionDetailParam param) {
        collectDriverTransportIntentionService.deleteCarrierDriverCollectTransportIntention(param);
        return Result.ok();
    }

    @Operation(summary = "启用/禁用", description = "<br>By:马路路")
    @PostMapping("/enable")
    public Result<Object> enableCarrierDriverCollectTransportIntention(@RequestBody @Validated CarrierDriverCollectTransportIntentionEnableParam param) {
        collectDriverTransportIntentionService.enableCarrierDriverCollectTransportIntention(param);
        return Result.ok();
    }

    @Operation(summary = "列表", description = "<br>By:马路路")
    @PostMapping("/list")
    public Result<PageData<CarrierDriverCollectTransportIntentionVO>> listCarrierDriverCollectTransportIntention(@RequestBody CarrierDriverCollectTransportIntentionListParam param) {
        IPage<CarrierDriverCollectTransportIntentionVO> page = collectDriverTransportIntentionService.listCarrierDriverCollectTransportIntention(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "查看选项详情", description = "<br>By:马路路")
    @PostMapping("/detail")
    public Result<List<CarrierDriverCollectTransportIntentionRecordVO>> detailCarrierDriverCollectTransportIntention(@RequestBody CarrierDriverCollectTransportIntentionDetailParam param) {
        return Result.ok(collectDriverTransportIntentionService.detailCarrierDriverCollectTransportIntention(param));
    }

    @Operation(summary = "进行中数据调整顺序", description = "<br>By:马路路")
    @GetMapping("/updateAdjustOrder")
    public Result<Object> updateAdjustOrder (@RequestParam("adjustOrderOneId") @NotNull(message = "调整订单1的id不能为空") Integer adjustOrderId,
                                             @RequestParam("adjustOrderTwoId") @NotNull(message = "调整订单2的id不能为空") Integer adjustOrderBeforeId) {
        collectDriverTransportIntentionService.updateAdjustOrder(adjustOrderId,adjustOrderBeforeId);
        return Result.ok();
    }

}
