/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.util.encoders.Base64;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ExtendInfoUtil {
    public String getCertificateDetail(X509Certificate cert, int type) {
        String result = null;
        String[] issuerMsg = null;
        String[] subjectMsg = null;
        if (type >= 4 && type <= 10) {
            issuerMsg = this.getDNMessage(cert.getIssuerDN().toString());
        } else if (type >= 14 && type <= 20) {
            subjectMsg = this.getDNMessage(cert.getSubjectDN().toString());
        }
        switch (type) {
            case 1: {
                result = "" + cert.getVersion();
                break;
            }
            case 2: {
                result = cert.getSerialNumber().toString(16);
                break;
            }
            case 3: {
                result = cert.getIssuerDN().toString();
                break;
            }
            case 4: {
                result = issuerMsg[0];
                break;
            }
            case 5: {
                result = issuerMsg[1];
                break;
            }
            case 6: {
                result = issuerMsg[2];
                break;
            }
            case 7: {
                result = issuerMsg[3];
                break;
            }
            case 8: {
                result = issuerMsg[4];
                break;
            }
            case 9: {
                result = issuerMsg[5];
                break;
            }
            case 10: {
                result = issuerMsg[6];
                break;
            }
            case 11: {
                result = this.formatDate(cert.getNotBefore());
                break;
            }
            case 12: {
                result = this.formatDate(cert.getNotAfter());
                break;
            }
            case 13: {
                result = cert.getSubjectDN().toString();
                break;
            }
            case 14: {
                result = subjectMsg[0];
                break;
            }
            case 15: {
                result = subjectMsg[1];
                break;
            }
            case 16: {
                result = subjectMsg[2];
                break;
            }
            case 17: {
                result = subjectMsg[3];
                break;
            }
            case 18: {
                result = subjectMsg[4];
                break;
            }
            case 19: {
                result = subjectMsg[5];
                break;
            }
            case 20: {
                result = subjectMsg[6];
                break;
            }
            case 21: {
                byte[] utmp = cert.getExtensionValue("2.5.29.15");
                if (utmp == null) break;
                result = new String(Base64.encode((byte[])utmp));
                break;
            }
            case 22: {
                try {
                    List<String> list = cert.getExtendedKeyUsage();
                    if (list == null) break;
                    String str = list.toString();
                    result = new String(Base64.encode((byte[])str.substring(1, str.length() - 1).getBytes()));
                }
                catch (CertificateParsingException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 23: {
                byte[] tmp = cert.getExtensionValue("2.5.29.32");
                if (tmp == null) break;
                result = new String(Base64.encode((byte[])tmp));
                break;
            }
            case 24: {
                byte[] ptmp = cert.getExtensionValue("2.5.29.33");
                if (ptmp == null) break;
                result = new String(Base64.encode((byte[])ptmp));
                break;
            }
            case 25: {
                byte[] btmp = cert.getExtensionValue("2.5.29.19");
                if (btmp == null) break;
                result = new String(Base64.encode((byte[])btmp));
                break;
            }
            case 26: {
                byte[] pctmp = cert.getExtensionValue("2.5.29.36");
                if (pctmp == null) break;
                result = new String(Base64.encode((byte[])pctmp));
                break;
            }
            case 27: {
                byte[] ctmp = cert.getExtensionValue("2.5.29.31");
                if (ctmp == null) break;
                result = new String(Base64.encode((byte[])ctmp));
                break;
            }
            case 28: {
                byte[] etmp = cert.getExtensionValue("1.2.156.2316");
                if (etmp == null) break;
                result = new String(Base64.encode((byte[])etmp));
            }
        }
        return result;
    }

    private String formatDate(Date date) {
        SimpleDateFormat defaultFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = defaultFormatter.format(date);
        return dateStr;
    }

    private String[] getDNMessage(String dn) {
        String[] result = new String[7];
        if (dn == null || dn.equals("")) {
            return result;
        }
        String[] tmp = dn.split("(?<!\\\\)[,;]");
        int i = 0;
        while (i < tmp.length) {
            String entry = tmp[i];
            String[] doub = entry.split("=");
            if (doub[0].trim().equals("C")) {
                result[0] = doub[1].trim();
            } else if (doub[0].trim().equals("O")) {
                result[1] = doub[1].trim();
            } else if (doub[0].trim().equals("OU")) {
                result[2] = doub[1].trim();
            } else if (doub[0].trim().equals("ST")) {
                result[3] = doub[1].trim();
            } else if (doub[0].trim().equals("CN")) {
                result[4] = doub[1].trim();
            } else if (doub[0].trim().equals("L")) {
                result[5] = doub[1].trim();
            } else if (doub[0].trim().equals("E")) {
                result[6] = doub[1].trim();
            }
            ++i;
        }
        return result;
    }

    public String GetUserInfoByOid(X509Certificate certificate, String Oid) {
        String result = null;
        byte[] tmp = certificate.getExtensionValue(Oid);
        if (tmp != null) {
            result = new String(tmp);
        }
        return result;
    }
}

