package com.clx.performance.service.trace;

import com.clx.performance.param.temp.DriverTraceAddParam;
import com.clx.performance.param.temp.TruckTraceAddParam;
import com.clx.performance.vo.pc.trace.DriverTraceVO;
import com.clx.performance.vo.pc.trace.DriverTruckTraceVO;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public interface TruckTraceService {

    List<DriverTruckTraceVO> listTruckTraceByTime(String truckNo, String beginTime, String endTime);
    List<DriverTraceVO> listDriverTraceByTime(Long userNo, String beginTime, String endTime);

    void truckTraceSave(TruckTraceAddParam param);

    void driverTraceSave(DriverTraceAddParam param);

    BigDecimal[] getCurrentPosition(String truckNo, Long userNo);

    int getParkTime(String truckNo, Long userNo);
    int getParkTime(String truckNo, Long userNo, LocalDateTime beginTime);


    BigDecimal[] getCurrentTruckPosition(String truckNo);


    List<List<DriverTraceVO>> splitDriverTrace(List<DriverTraceVO> driverTraceList);


    List<DriverTruckTraceVO> calcTruckStayTime(List<DriverTruckTraceVO> traceList);

    List<DriverTraceVO> calcDriverStayTime(List<DriverTraceVO> traceList);

    List<List<DriverTruckTraceVO>> splitTruckTrace(List<DriverTruckTraceVO> traceList);
}
