package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 油表上报信息
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectTruckRefuel implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private String truckNo;                         //车牌号
    private String childNo;                         //运单编号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private String loadImage;                       //装车油表list集合
    private BigDecimal loadOil;                     //装车油量
    private String unloadImage;                     //卸车油表list集合
    private BigDecimal unloadOil;                   //卸车油量
    private LocalDateTime reportTime;               //上报时间
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}