package com.clx.performance.dao.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnInfoDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnInfoEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnRangEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnInfoMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

@Repository
public class VehicleWarnInfoDaoImpl extends BaseDaoImpl<VehicleWarnInfoMapper, VehicleWarnInfo, Integer> implements VehicleWarnInfoDao {

    @Override
    public boolean updateStatus(VehicleWarnInfo item) {
        return update(lUdWrapper()
                .eq(VehicleWarnInfo::getId, item.getId())
                .set(VehicleWarnInfo::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean batchUpdateStatus(List<Integer> idList, Integer status) {
        return update(lUdWrapper()
                .in(VehicleWarnInfo::getId, idList)
                .set(VehicleWarnInfo::getStatus, status)
        );
    }

    @Override
    public boolean updateSuspendTime(VehicleWarnInfo item, Integer warnRang) {

        if (Objects.equals(warnRang, VehicleWarnRangEnum.WarnRange.CHILD.getCode())) {
            return update(lUdWrapper()
                    .eq(VehicleWarnInfo::getId, item.getId())
                    .ne(VehicleWarnInfo::getStatus, VehicleWarnInfoEnum.Status.RESOLVE.getCode())
                    .set(VehicleWarnInfo::getSuspendTime, item.getSuspendTime())
            );
        }
        else if (Objects.equals(warnRang, VehicleWarnRangEnum.WarnRange.ORDER_GOODS.getCode())) {
            return update(lUdWrapper()
                    .eq(VehicleWarnInfo::getWarnConfigId, item.getWarnConfigId())
                    .eq(VehicleWarnInfo::getOrderGoodsNo, item.getOrderGoodsNo())
                    .ne(VehicleWarnInfo::getStatus, VehicleWarnInfoEnum.Status.RESOLVE.getCode())
                    .set(VehicleWarnInfo::getSuspendTime, item.getSuspendTime())
            );
        }
        else {
            return update(lUdWrapper()
                    .eq(VehicleWarnInfo::getWarnConfigId, item.getWarnConfigId())
                    .ne(VehicleWarnInfo::getStatus, VehicleWarnInfoEnum.Status.RESOLVE.getCode())
                    .set(VehicleWarnInfo::getSuspendTime, item.getSuspendTime())
            );
        }
    }

    @Override
    public boolean updateWarnTime(VehicleWarnInfo item) {
        return update(lUdWrapper()
                .eq(VehicleWarnInfo::getId, item.getId())
                .set(VehicleWarnInfo::getWarnTime, item.getWarnTime())
        );
    }

    @Override
    public boolean updateByConfig(Integer warnConfigId, String warnName, Integer warnLevel) {
        return update(lUdWrapper()
                .eq(VehicleWarnInfo::getWarnConfigId, warnConfigId)
                .set(VehicleWarnInfo::getWarnName, warnName)
                .set(VehicleWarnInfo::getWarnLevel, warnLevel)
        );
    }

    @Override
    public Optional<VehicleWarnInfo> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnInfo::getId, id)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<VehicleWarnInfo> findByChildNoAndWarnConfigId(String childNo, Integer warnConfigId) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnInfo::getChildNo, childNo)
                        .eq(VehicleWarnInfo::getWarnConfigId, warnConfigId)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<VehicleWarnInfo> listSuspendTimeout() {
        return list(lQrWrapper()
                .eq(VehicleWarnInfo::getStatus, VehicleWarnInfoEnum.Status.SUSPEND.getCode())
                .lt(VehicleWarnInfo::getSuspendTime, LocalDateTime.now())
        );
    }


    @Override
    public IPage<VehicleWarnInfo> pageByParam(PageVehicleWarnInfoParam param) {
        Page<VehicleWarnInfo> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
