package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_account_approve")
public class OwnerLoanAccountApprove implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @Schema(description="货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @Schema(description="货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @Schema(description="联系电话")
    private String mobile;

    @TableField("account_type")
    @Schema(description="账户类型 默认3 借款账户")
    private Integer accountType;

    @TableField("status")
    @Schema(description="待审批 10，审批成功 20，审批拒绝 30")
    private Integer status;

    @TableField("approve_time")
    @Schema(description="审批时间")
    private LocalDateTime approveTime;

    @TableField("approve_by")
    @Schema(description="审批人")
    private String approveBy;

    @TableField("reject_reason")
    @Schema(description="拒绝原因")
    private String rejectReason;

    @TableField("create_by")
    @Schema(description="创建人")
    private String createBy;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
