package com.clx.performance.vo.pc.linewarn;

import com.clx.performance.enums.OrderChildEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;


@Getter
@Setter
@NoArgsConstructor
public class LineWarnTruckTraceInfoVO {

        @Schema(description = "运单编号", example = "100000")
        private String childNo;
        @Schema(description = "车牌号", example = "京A12345")
        private String truckNo;
        @Schema(description = "司机用户编号", example = "100000")
        private Long driverUserNo;
        @Schema(description = "司机姓名", example = "张三")
        private String driverName;
        @Schema(description = "司机手机号", example = "13000000000")
        private String driverMobile;
        @Schema(description = "车辆状态：1空车 2重车", example = "1")
        private Integer truckStatus;
        @Schema(description = "运单状态", example = "1")
        private Integer status;
        @Schema(description = "运单状态", example = "1")
        private String statusMsg;
        public String getStatusMsg() {
                return OrderChildEnum.Status.getMsgByCode(status);
        }
        @Schema(description="经度")
        private BigDecimal longitude;
        @Schema(description="纬度")
        private BigDecimal latitude;

}