package com.clx.performance.param.pc.vehiclewarn;

import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnUserConfigUpdateParam {

    @Schema(description = "id", example = "1")
    @NotNull(message = "id不能为空")
    private Integer id;
    @Schema(description = "运单预警类型列表")
    private List<VehicleWarnUserVO.WarnTypeItem> warnTypeList;
    @Schema(description = "线路预警类型列表")
    private List<VehicleWarnUserVO.WarnTypeItem> lineWarnTypeList;

}
