package com.clx.performance.service.impl.settle;


import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.dto.PayStatusNotifyDTO;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.service.settle.OrderChildSyncTransportRecordService;
import com.clx.performance.struct.settle.SettlementDriverDetailStruct;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author kavin
 * Date 2023-12-08
 * Time 11:42
 */
@Service
@Slf4j
@AllArgsConstructor
public class OrderChildSyncTransportRecordServiceImpl implements OrderChildSyncTransportRecordService {

    private final OrderChildSyncTransportRecordDao orderChildSyncTransportRecordDao;

    private final SettlementDriverDetailStruct struct;

    @Override
    public void addOrderChildSyncTransportRecord(SettlementDriverDetail detail) {
        OrderChildSyncTransportRecord record = struct.convertRecord(detail);
        //0：未同步
        record.setStatus(0);
        orderChildSyncTransportRecordDao.saveEntity(record);
    }

    @Override
    public void updateStatus(PayStatusNotifyDTO payStatusNotifyDTO) {
        String childNo = payStatusNotifyDTO.getChildNo();
        orderChildSyncTransportRecordDao.updateStatus(childNo);
    }
}
