package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectTrafficCongestion;
import com.clx.performance.param.app.collect.PageCollectTraficCongestionParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam;
import com.clx.performance.sqlProvider.collect.CollectTrafficCongestionSqlProvider;
import com.clx.performance.vo.pc.collect.CollectTrafficCongestionVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 道路拥堵情况
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectTrafficCongestionMapper extends BaseMapper<CollectTrafficCongestion> {
    /**
     * @see CollectTrafficCongestionSqlProvider#pageTraffic(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectTraficCongestionParam)
     */
    @SelectProvider(type = CollectTrafficCongestionSqlProvider.class, method = "pageTraffic")
    IPage<CollectTrafficCongestionVO> pageTraffic(@Param("page") Page<CollectTrafficCongestionVO> page, @Param("param") PageCollectTraficCongestionParam param);

    /**
     * @see CollectTrafficCongestionSqlProvider#carrierPageTraffic(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam)
     */
    @SelectProvider(type = CollectTrafficCongestionSqlProvider.class, method = "carrierPageTraffic")
    IPage<CollectTrafficCongestionVO> carrierPageTraffic(@Param("page") Page<CollectTrafficCongestionVO> page, @Param("param") CarrierPageCollectTraficCongestionParam param);

}