package com.clx.performance.dao.impl.settle;

import com.clx.performance.dao.settle.SettlementLogDao;
import com.clx.performance.mapper.settle.SettlementLogMapper;
import com.clx.performance.model.settle.SettlementLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 结算单日志
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementLogDaoImpl extends BaseDaoImpl<SettlementLogMapper, SettlementLog, Integer> implements SettlementLogDao {

    @Override
    public List<SettlementLog> getSettlementLogs(String settlementNo) {
        return super.list(lQrWrapper()
                .eq(SettlementLog::getSettlementNo, settlementNo)
                .orderByDesc(SettlementLog::getId));
    }
}
