package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.IntegralOrderAddParam;
import com.clx.performance.param.pc.pageIntegralOrderParam;
import com.clx.performance.service.IntegralOrderService;
import com.clx.performance.vo.pc.IntegralOrderVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral")
@Validated
@Api(tags = "承运端-积分货单")
@AllArgsConstructor
public class IntegralOrderController {

    private final IntegralOrderService integralOrderService;

    @Deprecated
    @ApiOperation(value = "新增货单", notes = "<br>By:艾庆国")
//    @PostMapping(value = "addOrder")
    public Result<?> addOrder(@RequestBody @Validated IntegralOrderAddParam param) {

        integralOrderService.addOrder(param);

        return Result.ok();
    }

    @Deprecated
    @ApiOperation(value = "获取货单列表", notes = "<br>By:艾庆国")
//    @PostMapping(value = "pageOrderList")
    public Result<PageData<IntegralOrderVO>> pageOrderList(@RequestBody @Validated pageIntegralOrderParam param) {

        IPage<IntegralOrderVO> page = integralOrderService.pageOrderList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

}
