package com.clx.performance.vo.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class ThirdOrderChildBrokerResultVO {

    @ApiModelProperty(value = "风控结果列表，空未风控")
    private List<RiskItem> riskList;

    @ApiModelProperty(value = "合规状态：0不合规 1合规")
    private Integer status;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    public static class RiskItem {
        @ApiModelProperty(value = "类型", example = "PRICE_LOW")
        private String type;

        @ApiModelProperty(value = "风控原因", example = "运费单价过低")
        private String msg;
    }

}
