package com.clx.performance.param.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotBlank;

/**
 * @ClassName TruckTraceParam
 * @Description
 * @Author kavin
 * @Date 2023/11/13 9:47
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TruckTraceParam {

    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty("车牌号")
    private String truckNo;
    @NotBlank(message = "开始时间不能为空")
    @ApiModelProperty(value = "开始时间",example = "2023-11-11 12:00:00")
    private String beginTime;
    @NotBlank(message = "结束时间不能为空")
    @ApiModelProperty(value = "结束时间",example = "2023-11-11 12:00:00")
    private String endTime;
}
