package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerSettlementSyncParam {

    @ApiModelProperty(value = "货主手机")
    @NotBlank(message = "货主手机不能为空")
    private String ownerMobile;

    @ApiModelProperty(value = "结算单列表")
    @Valid
    @NotEmpty(message = "结算单列表不能空")
    private List<SettlementItem> settlementList;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class SettlementItem{
        @ApiModelProperty(value = "运单编号列表")
        @NotEmpty(message = "运单编号不能空")
        private String childNo;

        @ApiModelProperty(value = "结算单编号")
        @NotEmpty(message = "结算单编号不能空")
        private String settlementNo;

    }
}
