package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildRejectParam extends PositionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String orderGoodsNo;

    @ApiModelProperty(value = "车牌号id", example = "京A12345")
    @NotNull(message = "车牌号不能空")
    private String truckNo;

}
