package com.clx.performance.service.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dto.InvoicingStatusNotifyDTO;
import com.clx.performance.param.pc.owner.*;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.clx.performance.vo.pc.owner.settle.OwnerPageSettlementOwnerVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
public interface SettlementOwnerService {

    CarrierSettlementOwnerDetailVO getCarrierSettlementOwnerDetail(Integer id);

    void updateConfirmSettlement(Integer id);

    SettlementPlatformAccountVO getSettlementPlatformAccount();

    SettlementPlatformAccountVO getCarrierSettlementPlatformAccount(String settlementNo);

    void updatePaymentSettlement(OwnerPaymentSettlementParam param);

    void updatePaymentConfirmSettlement(Integer id);

    IPage<CarrierPageSettlementOwnerVO> pageCarrierSettlementOwner(PageCarrierSettlementOwnerParam param);


    IPage<OwnerPageSettlementOwnerVO> pageSettlementOwner(PageOwnerSettlementParam param);


    SXSSFWorkbook exportCarrierSettlementOwnerPageList(PageCarrierSettlementOwnerParam param);

    CarrierSettlementOwnerCompanyVO getCarrierSettlementOwnerInvoiceCompany(Integer id);

    CarrierSettlementOwnerCompanyContactVO getCarrierSettlementOwnerCompanyContact(Integer id);

    CarrierSettlementOwnerPayeeVO getCarrierSettlementOwnerPayee(Integer id);

    CarrierSettlementOwnerExpressVO getCarrierSettlementOwnerExpress(Integer id);

    void uploadInvoiceImg(UploadInvoiceImgParam param);

    void saveExpress(SaveExpressParam param);

    void savePayee(SavePayeeParam param);

    void updateStatusByOrderNo(String orderNo, Integer settlementPeriodType, Integer fromStatus, Integer toStatus);

    void payeeConfirm(String settlementNo);

    void invoicingStatusNotify(InvoicingStatusNotifyDTO invoicingStatusNotifyDTO);
}
