package com.clx.performance.model.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @ClassName CustomerComplaintType
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:54
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CustomerComplaintDetail implements HasKey<Integer> {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    private Long driverUserNo;                      //司机用户编号
    private String driverName;                      //司机姓名
    private String driverMobile;                    //司机手机号
    private String childNo;                         //运单编号
    private Integer complaintTypeId;             //投诉类型id
    private String content;                      //问题描述
    private String picture;                      //图片
    private String createTime;                      //创建时间
    private String modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }


}
