package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectLineReportDao;
import com.clx.performance.mapper.collect.CollectLineReportMapper;
import com.clx.performance.model.collect.CollectLineReport;
import com.clx.performance.param.app.collect.PageCollectLineReportParam;
import com.clx.performance.param.pc.carrier.*;
import com.clx.performance.vo.pc.collect.CollectLineReportVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 线路信息上报
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectLineReportDaoImpl extends BaseDaoImpl<CollectLineReportMapper, CollectLineReport, Integer> implements CollectLineReportDao {

    @Override
    public boolean updateAuditStatus(CollectLineReport item) {
        return update(lUdWrapper()
                .eq(CollectLineReport::getId, item.getId())
                .set(CollectLineReport::getAuditStatus, item.getAuditStatus())
        );
    }

    @Override
    public IPage<CollectLineReportVO> pageLineReport(PageCollectLineReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageLineReport(page,param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageSendAddressReport(CarrierPageCollectSendAddressReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageSendAddressReport(page,param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageAbnormalReport(CarrierPageCollectAbnormalReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageAbnormalReport(page,param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageNoTakeOrderReport(CarrierPageCollectNoTakeOrderReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageNoTakeOrderReport(page,param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageQualityReport(CarrierPageCollectQualityReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageQualityReport(page,param);
    }

    @Override
    public IPage<CollectLineReportVO> carrierPageOtherReport(CarrierPageCollectOtherReportParam param) {
        Page<CollectLineReportVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageOtherReport(page,param);
    }

}
