package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.*;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.service.OwnerCaseOutService;
import com.clx.performance.service.OwnerTopUpService;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.performance.vo.pc.OwnerCaseOutVO;
import com.clx.performance.vo.pc.OwnerTopUpVO;
import com.clx.user.param.pc.driver.truck.PageDriverTruckParam;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier")
@Validated
@Api(tags = "承运端-资金")
@AllArgsConstructor
public class CarrierAccountController {

    private final OwnerAccountService ownerAccountService;

    private final OwnerTopUpService ownerTopUpService;

    private final OwnerCaseOutService ownerCaseOutService;


    @ApiOperation(value = "查看资金管理列表(保证金和预付运费)", notes = "<br>By:胡宇帆")
    @PostMapping("/pageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountVO>> pageList(@RequestBody PageOwnerAccountListParam param) {
        IPage<OwnerAccountVO> page = ownerAccountService.pageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "保证金账户详情流水列表", notes = "<br>By:胡宇帆")
    @PostMapping("/marginAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> marginAccountPageList(@RequestBody PagePlatformMarginAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.marginAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "保证金账户详情流水下载")
    @PostMapping("/exportMarginAccountPageList")
    public void exportMarginAccountPageList(@RequestBody @Validated PagePlatformMarginAccountParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerAccountService.exportMarginAccountPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @ApiOperation(value = "预付金账户详情流水列表", notes = "<br>By:胡宇帆")
    @PostMapping("/prepaidFreightAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> prepaidFreightAccountPageList(@RequestBody PagePlatformPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.prepaidFreightAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "预付金账户详情流水下载")
    @PostMapping("/exportPrepaidFreightAccountPageList")
    public void exportPrepaidFreightAccountPageList(@RequestBody @Validated PagePlatformPrepaidFreightAccountParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerAccountService.exportPrepaidFreightAccountPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }


    @ApiOperation(value = "充值审批", notes = "<br>By:胡宇帆")
    @PostMapping("/accountTopUpApprove")
    public Result<Object> accountTopUpApprove(@RequestBody PlatformAccountTopUpParam param) {
        ownerAccountService.accountTopUpApprove(param);
        return Result.ok();
    }

    @ApiOperation(value = "提现审批", notes = "<br>By:胡宇帆")
    @PostMapping("/accountCaseOutApprove")
    @UnitCovert()
    public Result<Object> accountCaseOutApprove(@RequestBody OwnerCaseOutApproveParam param) {
        ownerAccountService.accountCaseOutApprove(param);
        return Result.ok();
    }

    @ApiOperation(value = "充值审批列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerTopUpPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerTopUpVO>> ownerTopUpPageList(@RequestBody PageOwnerTopUpListParam param) {
        IPage<OwnerTopUpVO> page = ownerTopUpService.ownerTopUpPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "提现审批列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerCaseOutPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerCaseOutVO>> ownerCaseOutPageList(@RequestBody PageOwnerCaseOutListParam param) {
        IPage<OwnerCaseOutVO> page = ownerCaseOutService.ownerCaseOutPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
