package com.clx.performance.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Author liumingchao
 * @Date 2023/7/26 11:45
 */
@Getter
@Setter
@Configuration
@ConfigurationProperties(prefix = "notice")
public class NoticeConfig {

    private Sms sms = new Sms();


    @Getter
    @Setter
    @Configuration
    @ConfigurationProperties(prefix = "notice.sms")
    public static class Sms {

        private boolean enable = true;

        private Template template = new Template();
        @Getter
        @Setter
        @Configuration
        @ConfigurationProperties(prefix = "notice.sms.template")
        public static class Template {
            /**
             * 通知客户化验结果
             */
            private String assayResultNotice = "assayResultNotice";
        }

    }


}
