/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.ConsoleLogger;
import cn.com.infosec.netsign.der.util.DERObject;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataGenerater;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;

public class PKCS7SignedData
implements DERObject {
    private byte[] signedDataOid;
    private String digestAlgOid;
    private byte[] content;
    private Certificate[] certs;
    private String digestEncryptionAlgOid;
    private String signCertIssuerSubject;
    private byte[] signCertIssuerSubjectDer;
    private BigInteger signCertSN;
    private byte[] signature;
    private byte[] p7;
    private X509Certificate signCert;
    private HashMap authenticatedAttributes = new HashMap();
    private byte[] authenticatedAttributesData;

    public byte[] getSignedDataOID() {
        return this.signedDataOid;
    }

    public void setSignedDataOID(byte[] signedDataOID) {
        this.signedDataOid = signedDataOID;
    }

    public byte[] getEncoded() throws IOException, CertificateException {
        if (this.p7 == null) {
            this.p7 = new PKCS7SignedDataGenerater(this).generatePKCS7SignedData();
        }
        return this.p7;
    }

    public byte[] getSignCertIssuerSubjectDer() {
        if (this.signCertIssuerSubjectDer != null) {
            return this.signCertIssuerSubjectDer;
        }
        if (this.signCertIssuerSubject != null) {
            X500Principal xp = new X500Principal(this.signCertIssuerSubject);
            this.signCertIssuerSubjectDer = xp.getEncoded();
            return this.signCertIssuerSubjectDer;
        }
        return null;
    }

    public void setSignCertIssuerSubjectDer(byte[] signCertIssuerSubjectDer) {
        this.signCertIssuerSubjectDer = signCertIssuerSubjectDer;
        this.p7 = null;
    }

    public String getDigestAlgOid() {
        return this.digestAlgOid;
    }

    public void setDigestAlgOid(String digestAlgOid) {
        this.digestAlgOid = digestAlgOid;
        this.p7 = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
        this.p7 = null;
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    public void setCerts(Certificate[] certs) {
        this.certs = certs;
        this.p7 = null;
    }

    public void addCert(Certificate cert) {
        Certificate[] tmp;
        this.p7 = null;
        Certificate[] certificateArray = tmp = this.certs == null ? new Certificate[1] : new Certificate[this.certs.length + 1];
        if (this.certs == null) {
            tmp[0] = cert;
            this.certs = tmp;
        } else {
            System.arraycopy(this.certs, 0, tmp, 0, this.certs.length);
            tmp[this.certs.length] = cert;
            this.certs = tmp;
        }
    }

    public String getDigestEncryptionAlgOid() {
        return this.digestEncryptionAlgOid;
    }

    public void setDigestEncryptionAlgOid(String digestEncryptionAlgOid) {
        this.digestEncryptionAlgOid = digestEncryptionAlgOid;
        this.p7 = null;
    }

    public String getSignCertIssuerSubject() {
        if (this.signCertIssuerSubject != null) {
            return this.signCertIssuerSubject;
        }
        if (this.signCertIssuerSubjectDer != null) {
            X500Principal xp = new X500Principal(this.signCertIssuerSubjectDer);
            this.signCertIssuerSubject = xp.getName();
            return this.signCertIssuerSubject;
        }
        return null;
    }

    public void setSignCertIssuerSubject(String signCertIssuer) {
        this.signCertIssuerSubject = signCertIssuer;
        this.p7 = null;
    }

    public BigInteger getSignCertSN() {
        return this.signCertSN;
    }

    public void setSignCertSN(BigInteger signCertSN) {
        this.signCertSN = signCertSN;
        this.p7 = null;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
        this.p7 = null;
    }

    public X509Certificate getSignCert() {
        if (this.signCert == null) {
            if (this.certs != null && this.certs.length > 0) {
                X509Certificate cert = null;
                int i = 0;
                int length = this.certs.length;
                while (i < length) {
                    block7: {
                        try {
                            cert = (X509Certificate)this.certs[i];
                        }
                        catch (Exception e) {
                            ConsoleLogger.logException(e);
                            break block7;
                        }
                        if (this.signCertIssuerSubjectDer == null) {
                            this.getSignCertIssuerSubjectDer();
                        }
                        if (cert.getSerialNumber().equals(this.signCertSN) && DERUtil.equalsDN(cert.getIssuerX500Principal().getEncoded(), this.signCertIssuerSubjectDer)) {
                            this.signCert = cert;
                            return cert;
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        return this.signCert;
    }

    public void putAuthenticatedAttribute(byte[] oid, byte[] value) {
        this.authenticatedAttributes.put(new BigInteger(oid), value);
    }

    public byte[] getAuthenticatedAttribute(byte[] oid) {
        return (byte[])this.authenticatedAttributes.get(oid);
    }

    public byte[] getAuthenticateAttribute(String oid) {
        return (byte[])this.authenticatedAttributes.get(new BigInteger(DERUtil.oid2ASN1(oid)));
    }

    public HashMap getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public void setAuthenticateAttributesData(byte[] authAttrs) {
        this.authenticatedAttributesData = authAttrs;
    }

    public byte[] getAuthenticateAttributesData() {
        return this.authenticatedAttributesData;
    }
}

