/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.PBCAgent2G;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TestWanglian {
    private static String signdn;
    private static String encdn;

    static {
        encdn = signdn = "O=infosec,CN=sm2_rev";
    }

    public static void main(String[] args) throws Exception {
        TestWanglian.testEnc();
    }

    private static PBCAgent2G connectServer() {
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.89.240", 10001, "12345678");
        return agent;
    }

    private static void testEncFile() {
        ConsoleLogger.isDebug = true;
        PBCAgent2G agent = TestWanglian.connectServer();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream("d:\\temp\\1.pdf");
            out = new FileOutputStream("d:\\temp\\1.pdf.cipher");
            String env = agent.makeWangLianEnvelope(in, encdn, "AES", out);
            System.out.println(env);
            in.close();
            out.close();
            System.out.println("encrypt " + agent.getReturnCode());
            in = new FileInputStream("d:\\temp\\1.pdf.cipher");
            out = new FileOutputStream("d:\\temp\\2.pdf");
            agent.decryptWangLianEnvelope(env, in, encdn, out);
            in.close();
            out.close();
            System.out.println("decrypt " + agent.getReturnCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testEnc() {
        PBCAgent2G agent = TestWanglian.connectServer();
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = "123123".getBytes();
        byArrayArray[2] = "qwefsadfs".getBytes();
        String[] enced = agent.makeWangLianEnvelope(byArrayArray, encdn, "SM4");
        System.out.println(agent.getReturnCode());
        int i = 0;
        while (i < enced.length) {
            System.out.println(String.valueOf(i) + ":" + enced[i]);
            ++i;
        }
        enced[2] = null;
        byte[][] plaintexts = agent.decryptWangLianEnvelope(enced, encdn);
        System.out.println(agent.getReturnCode());
        int i2 = 0;
        while (i2 < plaintexts.length) {
            System.out.println(String.valueOf(i2) + ":" + new String(plaintexts[i2]));
            ++i2;
        }
        agent.closeSignServer();
    }

    /*
     * Exception decompiling
     */
    private static void testDec() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 161->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void testWangLianEnvelope() {
        String certid = "sm2_rev";
        String encAlg = "SM4";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        byte[] plain1 = "111111112222222233333333".getBytes();
        byte[] plain2 = "sdjkwqpfpio".getBytes();
        byte[] plain3 = "asdfoiweqjefpo91208934".getBytes();
        byte[][] plain = new byte[][]{plain1, plain2, plain3};
        String[] envelope = agent1.makeWangLianEnvelope(plain, certid, encAlg);
        System.out.println("ret:" + agent1.getReturnCode());
        System.out.println("encedkey:" + envelope[0]);
        int i = 1;
        while (i < envelope.length) {
            System.out.println("encedmsg(" + i + "):" + envelope[i]);
            ++i;
        }
        byte[][] deced = agent1.decryptWangLianEnvelope(envelope, certid);
        System.out.println("ret:" + agent1.getReturnCode());
        int i2 = 0;
        while (i2 < deced.length) {
            System.out.println("plain(" + (i2 + 1) + "):" + new String(deced[i2]));
            if (!Arrays.equals(deced[i2], plain[i2])) {
                System.out.print("decrypt failed");
                System.exit(0);
            }
            ++i2;
        }
        agent1.closeSignServer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readCrypto(String file) {
        String string;
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                byte[] bs = new byte[in.available()];
                in.read(bs);
                string = Base64.encode(bs);
                Object var3_5 = null;
                if (in == null) return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var3_6 = null;
                if (in == null) return null;
                try {
                    in.close();
                    return null;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException e2) {
                e2.printStackTrace();
                throw throwable;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            e2.printStackTrace();
            return string;
        }
        in.close();
        return string;
    }

    private static void testWangLianEnvelope2() {
        String certid = "sm2_rev";
        String encAlg = "SM4";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        String srcFile = "d:/1.txt";
        byte[] plain1 = TestWanglian.readFile(srcFile);
        byte[][] plain = new byte[][]{plain1};
        String[] envelope = agent1.makeWangLianEnvelope(plain, certid, encAlg);
        System.out.println("ret:" + agent1.getReturnCode());
        System.out.println("encedkey:" + envelope[0]);
        String chipherFile = "d:/1.txt.cipher";
        TestWanglian.writeFile(Base64.decode(envelope[1]), chipherFile);
        String cipherText = Base64.encode(TestWanglian.readFile(chipherFile));
        String[] cipher = new String[]{envelope[0], cipherText};
        byte[][] deced = agent1.decryptWangLianEnvelope(envelope, certid);
        System.out.println("ret:" + agent1.getReturnCode());
        TestWanglian.writeFile(deced[0], "d:/2.txt");
        agent1.closeSignServer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFile(String file) {
        byte[] byArray;
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                byte[] bs = new byte[in.available()];
                in.read(bs);
                byArray = bs;
                Object var3_5 = null;
                if (in == null) return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var3_6 = null;
                if (in == null) return null;
                try {
                    in.close();
                    return null;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException e2) {
                e2.printStackTrace();
                throw throwable;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            e2.printStackTrace();
            return byArray;
        }
        in.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean writeFile(byte[] content, String file) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                out.write(content);
                out.flush();
                Object var4_3 = null;
                if (out == null) return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var4_4 = null;
                if (out == null) return false;
                try {
                    out.close();
                    return false;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException e2) {
                e2.printStackTrace();
                throw throwable;
            }
            out.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            e2.printStackTrace();
            return true;
        }
        out.close();
        return true;
    }
}

