/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;
import java.util.Random;
import javax.crypto.Cipher;

public class TestRAWVerify {
    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
            PropertyResourceBundle res = new PropertyResourceBundle(in);
            NetSignAgent.initialize(res);
            TestRAWVerify.testSM2PublicKeyVerify2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testSM2PublicKeyVerify2() throws Exception {
        byte[] plainText = Base64.decode((String)"Az7aAQsuCQAwMDREIzAwMDEOLgcAAQABYwBjAQouIAB0bP7T8pdACHRv2/ksbVidZ6tzCXkgStUSNg2dExManAkuIAAxZGY3OGJiZDJlMzhhZjkzZGY0YTE5Y2NjMTdhNTE2ZA0uCAABAAAAAAAAAAwuJgEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCj6kiC5NyLwKw7EqJ9SqN8wxWRNdzuoo2TMs9QT6+uzI906JOQ/rAiPL4LtZjwYmSKkkZ+bwscIaQnU3fPG5LM9R4xUACPSjBe1pXh7ijonqBmxqvUprYGi6SVJyGCFdI8uNC/XqPz0OEOQBQT4v5or5gzXzAJ7fZi5+wgqvg8N5jh7FjLJmCm08t2wSt/yNQ9fwr0j1WbLgeebxZEVEkQwNFGxmEuuqz90fq/J4M70N3QuJ2p0Bew2rT7Ad1hbqdSKx2484mhoIZzMmsW/jHdpPkSVP7ODmJj9Hg8b89Rh/6gHxm6AuZddO6jljDjXgwt+1L+ztiuIReNRDtoIo1FAgMBAAEEAUAAN2ZkNDQxZDE3ZTFkOWYwZjQyODQyMzY5NWM0ODBjYmUyOWYzYmVhNDBiNDEyOGMxZWNmMjE2NDI1NGEzZGNiMA==");
        byte[] signed = Base64.decode((String)"ywU+xDT7yEEg9k8rgfLk26x4Z5VZPEG170S7U+QEKd/APKW7KqizsET/WdQ9hHatW0ZGV1vjmMm6l569RAOz7A==");
        byte[] pubkbs = Base64.decode((String)"xkWet1882wPvjpFgz280YODJbr1cR5PeJNIQFeiodecUXqvUGNUF4jBomKeYE/4WOAv8YlXGp/TeewnenptaEA==");
        JCESM2PublicKey pubk = new JCESM2PublicKey(pubkbs);
        NetSignAgent.rawVerify(plainText, signed, null, (PublicKey)pubk);
        System.out.println("verify ok");
    }

    private static void testSM2PublicKeyVerify() throws Exception {
        byte[] plainText = Base64.decode((String)"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48U2lnbkRhdGE+PFRyYWRlVHlwZSBuYW1lPSLooYzlhoXovazotKY6ICI+QmFua0lubmVyVHJhbnNmZXI8L1RyYWRlVHlwZT48VGltZXN0YW1wPjE0NDEwOTkxMjUxMTc8L1RpbWVzdGFtcD48RmllbGRzPjxQYXllckJhbmtBY1R5cGU+MDM8L1BheWVyQmFua0FjVHlwZT48UGF5ZXJBY05vPjYyMTQ5NjYzMDAwMDAwMDAzMDQ8L1BheWVyQWNObz48UGF5ZXJTdWJBY1NlcT4wMDAwPC9QYXllclN1YkFjU2VxPjxQYXllckN1cnJlbmN5PkNOWTwvUGF5ZXJDdXJyZW5jeT48UGF5ZWVBY05vIG5hbWU9IuaUtuasvuS6uui0puWPtzogIj42MjEyNDI4MjEwMDcwOTc1NzcwPC9QYXllZUFjTm8+PFBheWVlQWNOYW1lIG5hbWU9IuaUtuasvuS6uuWnk+WQjTogIj7pmYjlu7rls7A8L1BheWVlQWNOYW1lPjxBbW91bnQgbmFtZT0i6YeR6aKdOiAiPjE2LjAwPC9BbW91bnQ+PFJlbWFyaz7lvoDmnaXmrL48L1JlbWFyaz48UmVtYXJrTW9kZT4wPC9SZW1hcmtNb2RlPjxQYXllZUJhbmtBY1R5cGU+PC9QYXllZUJhbmtBY1R5cGU+PFRpbWVyVHlwZT48L1RpbWVyVHlwZT48QmVnaW5EYXRlPjwvQmVnaW5EYXRlPjxUaW1lckZyZXE+PC9UaW1lckZyZXE+PFRpbWVyUnVsZT48L1RpbWVyUnVsZT48VGltZXJJbmZvPjwvVGltZXJJbmZvPjxPcmRlclRpbWVzPjwvT3JkZXJUaW1lcz48VHJhbnNmZXJUeXBlPjA8L1RyYW5zZmVyVHlwZT48Q1JGbGFnPkM8L0NSRmxhZz48TWVzc2FnZU5vdGlmeT48L01lc3NhZ2VOb3RpZnk+PE1vYmlsZT48L01vYmlsZT48UGF5ZXJBY05hbWU+5a2U5b635byfPC9QYXllckFjTmFtZT48TW9iaWxlUGhvbmU+PC9Nb2JpbGVQaG9uZT48Q2hlY2tGbGFnPjwvQ2hlY2tGbGFnPjxDZXJ0QmFzZTY0PjwvQ2VydEJhc2U2ND48L0ZpZWxkcz48L1NpZ25EYXRhPl9QRVNpZ25UaW1lc3RhbXA9MTQ0MTA5OTEyNTExNw==");
        byte[] signed = Base64.decode((String)"KOm35r8+TCfxNunwYr392YLMUJGNDxWIjkdDoR1V0mkdlFW2fg0/EDDKZyq8CsY+hCLCrlscJl5Y3E+O2N9nmw==");
        byte[] certbs = Base64.decode((String)"MIICPDCCAeCgAwIBAgIFEAE4Y3MwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMTUwNzA5MDEzOTA4WhcNMTUxMDA5MDEzOTA4WjBfMQswCQYDVQQGEwJDTjENMAsGA1UECgwET0NBMTEPMA0GA1UECwwGVFBDLVMzMRUwEwYDVQQLDAxJbmRpdmlkdWFsLTMxGTAXBgNVBAMMEDk2MDE2NTAxMDAwMDA3MzQwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAASqu5wNTsNPUtxVyta32rucD+lhBxxYC53KryX28OGBPIuPwP1qpce9nNOu7bWgxVn6TH19FmFTWM66yY0nrprlo4GJMIGGMB8GA1UdIwQYMBaAFGv+GNqPQjqmuG2zLoiDOjSiwTDhMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmw4ODAuY3JsMAsGA1UdDwQEAwIDyDAdBgNVHQ4EFgQUnhiEC3hoJll1+LE3+q0PYWpYZ+EwDAYIKoEcz1UBg3UFAANIADBFAiA2ViE9E0V0KPXGSjz2HC6JUL5QQZlgcB6yoQ7/5diqlwIhAJhvK/5jk/VXR7Mo297SaIZ7XlPir7Ldb9Fjzzn23o4m");
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbs));
        NetSignAgent.rawVerify(plainText, signed, null, cert);
        System.out.println("verify ok");
    }

    private static void testDetached() throws Exception {
        byte[] plainText = "11111111".getBytes();
        NetSignResult result = NetSignAgent.detachedSignature(plainText, "CN=5year,O=syn080924,C=cn", null, false);
        String signed = result.getStringResult("Base64_Signed_Text");
        ConsoleLogger.logString(signed);
        result = NetSignAgent.detachedVerify(plainText, signed, null, false);
        System.out.println("subject:" + result.getStringResult("Sign_Subject"));
    }

    private static void verify(String signed) throws Exception {
        signed = "lD4D7Wr9GFNg8yhdDofq3QXj6DooLag/xeRBARunUvZuIq2QIlIHpS3hyJpRtvv1bB+kh0YwUeKbThGGhumO2vkTpwlH0QFQq2RzXXB8Io2AOXITfJDxgoKoDD7LCEfmsy1K5xTL84Q3z+MgQtPRlj1DpvjQBo6M1JU5JiXF6GvFHCTBZBgmEV5vPGp3hXx8VSGH9eXd9HqFpaaVboTJ3rOxxK1N/2s8Y334u1BAh4Rq52wN1Ue6YoIrbBIuuLfmu4hi4Ts1rvN8v2gaSCMvYAu6sFJgjybT5wM+Dsx43wtBeFloAX7P/vYsvegholjB2t183txapP919GZBJbuscA==";
        String certStr = "MIID+TCCAuGgAwIBAgIFEAAyBXkwDQYJKoZIhvcNAQEFBQAwGzELMAkGA1UEBhMCQ04xDDAKBgNVBAoTA0JPQzAeFw0xMzA5MjkwOTE3MDRaFw0xNDA5MjkwOTE3MDRaMF8xCzAJBgNVBAYTAkNOMQ0wCwYDVQQKEwRPQ0ExMQ8wDQYDVQQLEwZUUEMtUzMxFTATBgNVBAsTDEluZGl2aWR1YWwtMTEZMBcGA1UEAxMQOTYzMTIwMzIwMDAwMDA0MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALZA5aGT3KJdYWukqEmsZcQP0UTZFDRBEBhd6R7ey1eIBG3FG/NDNstx6U9T06S1/Gq0YDdKgbaYRjcrAx/iD6OZRkT06EhRd7f3eAogJOZIK3G1Fq2HTwRxaJ8KL19/T9eE0SM9ywT4dzcGeU90BvS/qRzIh9CY0WI57fZ0Cc/h3oLt+80r/AWYhavfVw5BTmbBol2AC93CtOh+3CH3/Mm/HsNNBOIA22rI+ldcnlr/RwAWcZ4KzIWu/ba9Y+HqGxzDR/TYSsvBjEBFQ21FxtZLPVrLCaN3C/FsDJ2mBGl2/Ayni68phmAJnb27OMSo+lb7tt8Y2QyhUP5iKwpRw20CAwEAAaOB/zCB/DAfBgNVHSMEGDAWgBTPcJ1h6518Lrj3ywJA9wmd/jN0gDBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1JTQS9jcmw0NzkuY3JsMAsGA1UdDwQEAwID6DAVBgkqgRyGoSAEAQcECAwGVFBDMi4wMB0GA1UdDgQWBBTELd5quCQXdPxzLSnCij7c7z6+uDATBgNVHSUEDDAKBggrBgEFBQcDAjANBgkqhkiG9w0BAQUFAAOCAQEAqewlzWc99UYGbCOwig8wQHSkEOjsjbGWfjiew81Z69VQpUj+8garVTXeSYgVnAAR54+SmvPHSvJCvIG/r/QmRCnWLeVh0dOPn1Ep96AFUWSw9A7ZtQc3MhCbM04RAnn6OKHmMHLhcISLnsUjzF6aEsINsDpEGor4CZU/NSmksqJn3hiCs+6lDYJ9VgczgG8pIBIIlFF0D4bz6dYYW1gWEMeLFCce5x7mTKL5bDhmr/JjmWTPAY4K33UyQJEWGs2DmodmoYhF7L4Z4PBRCi5U/G/76lm7HTc6+RIOooZFwnQ2vqsh+8dgcr3v+vbsj/qVAz+9kPnEpFjVmlvKdPRT4g==";
        String plainStr = "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";
        byte[] plain = Base64.decode((String)plainStr);
        X509Certificate cert = NetSignAgent.generateCertificate(certStr.getBytes());
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(2, cert.getPublicKey());
        byte[] dersa = c.doFinal(Base64.decode((String)signed));
        ConsoleLogger.logBinary("decode rsa", dersa);
        MessageDigest md = MessageDigest.getInstance("SHA256");
        byte[] dig = md.digest(plain);
        ConsoleLogger.logBinary("dig", dig);
        NetSignAgent.rawVerify(plain, signed, "SHA256", null, cert);
        System.out.println("verify ok");
    }

    private static String testSign() throws Exception {
        NetSignResult nsr = NetSignAgent.rawSignature("1234567890".getBytes(), "O=infosec,CN=sm2_rev", "SM3", false);
        String signed = nsr.getStringResult("Base64_Signed_Text");
        System.out.println(signed);
        String certstr = "MIICITCCAcWgAwIBAgIFKKvAPUgwDAYIKoEcz1UBg3UFADBFMQswCQYDVQQGEwJjbjEjMCEGA1UECgwaSU5GT1NFQyBUZWNobm9sb2dpZXMgU00ySUQxETAPBgNVBAMMCGFwcFNNMklEMB4XDTE0MDYyNzA1MzA1MFoXDTE5MDYyNjA1MzA1MFowJDEQMA4GA1UECgwHaW5mb3NlYzEQMA4GA1UEAwwHc20yX3JldjBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABJx0+qdyhQYAlrt9X7v1DFnND5JwhFvlHGUxT6ypB4F3NRK8Ihd8jwP9/6ylmBtxRcoCr5bi1t2mVKfihhrMr4mjgcAwgb0wHwYDVR0jBBgwFoAUFJzDJ+uBhRVDmSKM1PiIUJ/qEJswCQYDVR0TBAIwADBjBgNVHR8EXDBaMFigVqBUpFIwUDEOMAwGA1UEAwwFY3JsMTIxDDAKBgNVBAsMA2NybDEjMCEGA1UECgwaSU5GT1NFQyBUZWNobm9sb2dpZXMgU00ySUQxCzAJBgNVBAYTAmNuMAsGA1UdDwQEAwIHgDAdBgNVHQ4EFgQUyZ49rVQ6aqKvcvVhlTp7HDtukCswDAYIKoEcz1UBg3UFAANIADBFAiEA6ZMM82rVkur6up79M04LPBWLlL73EEmgHsjciGxCGz4CIGXctrXb/8zEBwkPJitZpg+BISv5JKgN0m8BfruXi43Y";
        NetSignAgent.rawVerify("1234567890".getBytes(), signed, "SHA1", null, NetSignAgent.generateCertificate(certstr.getBytes()));
        return signed;
    }

    private static void testVerify() throws Exception {
        Random ran = new Random();
        byte[] bs = new byte[64];
        ran.nextBytes(bs);
        JCESM2PublicKey pubk = new JCESM2PublicKey(bs);
        NetSignAgent.rawVerify(bs, bs, null, (PublicKey)pubk);
    }
}

