/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.service;

import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.agent.service.SelectorFactory;
import cn.com.infosec.netsign.agent.service.ServiceList;
import cn.com.infosec.netsign.agent.service.ServiceSelector;

public class ServiceManager {
    private ServiceList slist;
    private static ServiceList staticSlist;

    public ServiceManager(boolean isSingleServiceList) {
        if (!isSingleServiceList) {
            this.slist = new ServiceList();
        } else {
            ServiceManager.createSingleServiceList(this);
        }
    }

    private static synchronized void createSingleServiceList(ServiceManager sm) {
        if (staticSlist == null) {
            staticSlist = new ServiceList();
        }
        sm.slist = staticSlist;
    }

    public void addService(NSService s) {
        this.slist.addService(s);
    }

    public void addService(NetSignService s) {
        if (s != null) {
            NSPSService tmp = new NSPSService();
            tmp.setIp(s.getHost());
            tmp.setPort(s.getPort());
            tmp.setApiPasswd(s.getPwd());
            tmp.setTimeout(s.getTimeout());
            this.slist.addService(tmp);
        }
    }

    public void removeService(NSService s) {
        this.slist.removeService(s);
    }

    public ServiceList getAllService() {
        return this.slist.getAllServices();
    }

    public ServiceList getInnerAllService() {
        return this.slist;
    }

    public int contains(NSService s) {
        return this.slist.contains(s);
    }

    public ServiceSelector select() {
        return SelectorFactory.newServiceSecector(this.getAllService());
    }
}

