/*
 * Decompiled with CFR 0.152.
 */
package cn.cncc.bbms.sign;

import cn.cncc.bbms.common.X509CertInfo;
import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.ISignatureServiceImpl;
import cn.com.infosec.netsign.agent.PBCAgent2G;

public class InfosecSignatureServiceImpl
extends ISignatureServiceImpl {
    private int returnCode = 0;

    protected PBCAgent2G connect(String ip, int port, String pwd) {
        PBCAgent2G agent = new PBCAgent2G(true);
        if (agent.openSignServer(ip, port, pwd)) {
            this.returnCode = 0;
            return agent;
        }
        this.returnCode = agent.getReturnCode();
        agent.closeSignServer();
        return null;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String p1SignMsg(byte[] msg, String certname, String pwd, String ip, int port) {
        PBCAgent2G agent = this.connect(ip, port, pwd);
        if (agent != null) {
            String string;
            try {
                String signed = agent.rawSign(msg, certname);
                this.returnCode = agent.getReturnCode();
                string = signed;
                Object var8_9 = null;
                agent.closeSignServer();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                agent.closeSignServer();
                throw throwable;
            }
            return string;
        }
        return null;
    }

    public boolean p1VerifySignMsg(byte[] sourceData, String signData, String dn, byte[] certData, String ip, int port, String pwd) {
        PBCAgent2G agent = this.connect(ip, port, pwd);
        if (agent != null) {
            boolean bl;
            try {
                boolean ret = agent.rawVerify(sourceData, signData, dn);
                this.returnCode = agent.getReturnCode();
                bl = ret;
                Object var10_11 = null;
                agent.closeSignServer();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                agent.closeSignServer();
                throw throwable;
            }
            return bl;
        }
        return false;
    }

    public String p7SignMsg(byte[] msg, String certname, String pwd, String ip, int port) {
        PBCAgent2G agent = this.connect(ip, port, pwd);
        if (agent != null) {
            String string;
            try {
                String ret = agent.dettachedSign(msg, certname);
                this.returnCode = agent.getReturnCode();
                string = ret;
                Object var8_9 = null;
                agent.closeSignServer();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                agent.closeSignServer();
                throw throwable;
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509CertInfo p7VerifySignMsg(byte[] sourceData, String signData, String ip, int port, String pwd) {
        PBCAgent2G agent = this.connect(ip, port, pwd);
        if (agent == null) return null;
        try {
            boolean ret;
            GenericCertificate cert = agent.dettachedVerify(sourceData, signData);
            this.returnCode = agent.getReturnCode();
            if (cert != null && (ret = agent.uploadCert(null, cert.getCert()))) {
                X509CertInfo certInfo = new X509CertInfo();
                certInfo.setDn(cert.getSubject());
                certInfo.setSn(cert.getSer_number());
                certInfo.setBody(cert.getBase64Cert().getBytes());
                X509CertInfo x509CertInfo = certInfo;
                Object var10_11 = null;
                agent.closeSignServer();
                return x509CertInfo;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            agent.closeSignServer();
            throw throwable;
        }
        {
            Object var10_13 = null;
            agent.closeSignServer();
        }
        return null;
    }
}

