/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.util.base64;

import cn.com.infosec.util.base64.FormatException;
import cn.com.infosec.util.base64.MyCharacterDecoder;
import cn.com.infosec.util.base64.StreamExhausted;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MyBASE64Decoder
extends MyCharacterDecoder {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    byte[] decode_buffer = new byte[4];

    static {
        int i = 0;
        while (i < 255) {
            MyBASE64Decoder.pem_convert_array[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < pem_array.length) {
            MyBASE64Decoder.pem_convert_array[MyBASE64Decoder.pem_array[j]] = (byte)j;
            ++j;
        }
    }

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72;
    }

    protected void decodeAtom(InputStream inputstream, OutputStream outputstream, int i) throws IOException {
        int j;
        int byte0 = -1;
        int byte1 = -1;
        int byte2 = -1;
        int byte3 = -1;
        if (i < 2) {
            throw new FormatException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((j = inputstream.read()) != -1) continue;
            throw new StreamExhausted();
        } while (j == 10 || j == 13);
        this.decode_buffer[0] = (byte)j;
        j = this.readFully(inputstream, this.decode_buffer, 1, i - 1);
        if (j == -1) {
            throw new StreamExhausted();
        }
        if (i > 3 && this.decode_buffer[3] == 61) {
            i = 3;
        }
        if (i > 2 && this.decode_buffer[2] == 61) {
            i = 2;
        }
        switch (i) {
            case 4: {
                byte3 = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                byte2 = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                byte1 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                byte0 = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        switch (i) {
            case 2: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                break;
            }
            case 3: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                outputstream.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                break;
            }
            case 4: {
                outputstream.write((byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3));
                outputstream.write((byte)(byte1 << 4 & 0xF0 | byte2 >>> 2 & 0xF));
                outputstream.write((byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F));
            }
        }
    }
}

