/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.prng;

import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.prng.RandomGenerator;

public class DigestRandomGenerator
implements RandomGenerator {
    private long counter;
    private Digest digest;
    private byte[] state;

    public DigestRandomGenerator(Digest digest) {
        this.digest = digest;
        this.state = new byte[digest.getDigestSize()];
        this.counter = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedMaterial(byte[] inSeed) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            this.digestUpdate(inSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedMaterial(long rSeed) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            int i = 0;
            while (i != 8) {
                this.digestUpdate((byte)rSeed);
                rSeed >>>= 8;
                ++i;
            }
        }
    }

    public void nextBytes(byte[] bytes) {
        this.nextBytes(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] bytes, int start, int len) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            int stateOff = 0;
            this.digestDoFinal(this.state);
            int end = start + len;
            int i = start;
            while (i != end) {
                if (stateOff == this.state.length) {
                    this.digestUpdate(this.counter++);
                    this.digestUpdate(this.state);
                    this.digestDoFinal(this.state);
                    stateOff = 0;
                }
                bytes[i] = this.state[stateOff++];
                ++i;
            }
            this.digestUpdate(this.counter++);
            this.digestUpdate(this.state);
        }
    }

    private void digestUpdate(long seed) {
        int i = 0;
        while (i != 8) {
            this.digest.update((byte)seed);
            seed >>>= 8;
            ++i;
        }
    }

    private void digestUpdate(byte[] inSeed) {
        this.digest.update(inSeed, 0, inSeed.length);
    }

    private void digestDoFinal(byte[] result) {
        this.digest.doFinal(result, 0);
    }
}

