/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.agreement;

import cn.com.infosec.crypto.BasicAgreement;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import java.math.BigInteger;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    public void init(CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
        }
        if (!(kParam instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)kParam;
        this.dhParams = this.key.getParameters();
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        DHPublicKeyParameters pub = (DHPublicKeyParameters)pubKey;
        if (!pub.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return pub.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

