/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.util;

import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObjectIdentifier;

public class SubjectDNUtil {
    private static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    private static final String SORTDN_CN_FIRST = "cnfirst";
    private static final String SORTDN_CN_LAST = "cnlast";

    public static DEREncodable sortDN(ASN1Sequence dn, String pName) {
        String sort = System.getProperty(pName);
        if (sort == null || sort.equals("")) {
            return dn;
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)((ASN1Sequence)((ASN1Set)dn.getObjectAt(0)).getObjectAt(0)).getObjectAt(0);
        if (oid.equals(CN)) {
            if (sort.toLowerCase().equals(SORTDN_CN_FIRST)) {
                return dn;
            }
            if (sort.toLowerCase().equals(SORTDN_CN_LAST)) {
                return SubjectDNUtil.turnDN(dn);
            }
        } else {
            if (sort.toLowerCase().equals(SORTDN_CN_FIRST)) {
                return SubjectDNUtil.turnDN(dn);
            }
            if (sort.toLowerCase().equals(SORTDN_CN_LAST)) {
                return dn;
            }
        }
        return dn;
    }

    private static DEREncodable turnDN(ASN1Sequence dn) {
        DERConstructedSequence turneddn = new DERConstructedSequence();
        int i = 0;
        int size = dn.size();
        while (i < size) {
            turneddn.addObject(dn.getObjectAt(size - i - 1));
            ++i;
        }
        return turneddn;
    }
}

