package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
@Getter
@Setter
public class ExportOwnerLoanRecordVO {

    private Integer id;

   
    @Schema(description="货主编码")
    private String ownerUserNo;

   
    @Schema(description="货主名称")
    private String ownerUserName;

   
    @Schema(description="联系电话")
    private String mobile;

   
    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @Schema(description="商户流水号")
    private String merchantRunningWaterNo;

    @Schema(description="汇款识别码")
    private String remittanceIdentificationCode;

   
    @Schema(description="借款单号")
    private String loanNo;

   
    @Schema(description="借款类型 1:虚拟货币  2:资金")
    private Integer loanType;

    @Schema(description="借款类型 虚拟货币  资金")
    private String loanTypeMsg;

    public String getLoanTypeMsg(){
        return OwnerLoanRecordEnum.LoanType.getMsgByCode(loanType);
    }

    @Schema(description="借款金额")
    private BigDecimal loanBalance;


    public BigDecimal getLoanBalance(){
        return Objects.isNull(loanBalance)?BigDecimal.ZERO:loanBalance.movePointLeft(2);
    }



    @Schema(description="借出方")
    private String borrower;

    @Schema(description="借出方账户")
    private String borrowerAccount;


    @Schema(description="借出方银行")
    private String borrowerBank;


    @Schema(description="借出方银行行号")
    private String borrowerBankCode;

   
    @Schema(description="借款方")
    private String lendingParty;

   
    @Schema(description="借款方账户")
    private String lendingPartyAccount;

   
    @Schema(description="收款方")
    private String payee;

   
    @Schema(description="收款账户")
    private String payeeAccount;


    @Schema(description="收款银行")
    private String payeeBank;

    @Schema(description="收款行号")
    private String payeeBankCode;

   
    @Schema(description="10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;


    @Schema(description="10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanRecordEnum.Status.getMsgByCode(status);
    }


   
    @Schema(description="审批时间")
    private String approveTime;

   
    @Schema(description="审批人")
    private String approveBy;

   
    @Schema(description="拒绝原因")
    private String rejectReason;

   
    @Schema(description="借款归还时间")
    private String loanRepaymentTime;


    @Schema(description="支付渠道 1 订单支付 2 转账支付")
    private Integer payChannel;

    @Schema(description="支付渠道 1 订单支付 2 转账支付")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerLoanRecordEnum.PayChannel.getMsgByCode(payChannel);
    }

   
    @Schema(description="创建人")
    private String createBy;

   
    @Schema(description="创建时间")
    private String createTime;

   
    @Schema(description="修改时间")
    private String modifiedTime;

}
