package com.clx.performance.vo.pc.loan.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 借出方
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Schema(description = "借出方")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BorrowerVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "借出方", example = "1")
    private String name;
    @Schema(description = "所属银行", example = "工商银行")
    private String bankName;
    @Schema(description = "银行账号", example = "1111111111111111")
    private String bankCardNo;
    @Schema(description = "开户行行号", example = "313332082914")
    private String openBankId;
    @Schema(description = "开户行", example = "宁波银行")
    private String openBankName;
    @Schema(description = "状态：1启用 2禁用", example = "1")
    private Integer status;
    @Schema(description = "操作人编码", example = "1000000")
    private Long opUserNo;
    @Schema(description = "操作人", example = "张三")
    private String opUserName;
    @Schema(description = "操作时间", example = "")
    private String opTime;
    @Schema(description = "创建人编号", example = "1000000")
    private Long createBy;
    @Schema(description = "创建人名称", example = "张三")
    private String createName;
    @Schema(description = "创建时间", example = "")
    private String createTime;

}