package com.clx.performance.vo.pc.breakcontract.owner;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageOwnerBreakContractOwnerRecordVO {

    @Schema(description="id")
    private Integer id;

    @Schema(description="违约订单")
    private String orderNo;

    @Schema(description="违约金")
    @MoneyOutConvert
    private BigDecimal figure;

    @Schema(description="结算单编号")
    private String settlementNo;

    @Schema(description="缴费状态：0未缴费;1已缴费")
    private String payStatusMsg;

    @Schema(description="赔付状态：0未赔付;1已赔付")
    private String compensationStatusMsg;

    @Schema(description="缴费状态：0未缴费;1已缴费 /赔付状态：0未赔付;1已赔付")
    private Integer payStatus;

    @Schema(description="确认状态：0-确认中;1-已经确认;2-已驳回")
    private String confirmStatusMsg;

    @Schema(description="确认状态：0-确认中;1-已经确认;2-已驳回")
    private Integer confirmStatus;

    @Schema(description="驳回原因")
    private String rejectReason;

    @Schema(description="备注")
    private String remark;

    @Schema(description="违约时间")
    private String createTime;

    @Schema(description="赔付时间")
    private String payTime;

}
