package com.clx.performance.vo.pc;

import com.clx.open.sdk.enums.ExceptionReportEnum;
import com.clx.performance.enums.CarrierExceptionReportEnum;
import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-10-22
 * Time 10:38
 */
@Getter
@Setter
public class OrderChildExceptionReportVO {

   
    private Integer id;

    
    @Schema(description="异常上报编号")
    private String reportNo;

    
    @Schema(description="三方异常上报编号")
    private String thirdReportNo;

    
    @Schema(description="来源")
    private Integer source;

    @Schema(description="来源描述")
    private String sourceMsg;

    public String getSourceMsg(){
        return SyncPlatformEnum.Source.getNameByCode(source);
    }

    
    @Schema(description="异常类别")
    private String exceptionCategory;

    
    @Schema(description="异常类型")
    private String exceptionType;

    
    @Schema(description="车牌号/手机号")
    private String truckNoOrMobile;

    
    @Schema(description="运单编号")
    private String childNo;

    
    @Schema(description="状态：1：待处理  2：申诉中  3：已处理  4：已撤回")
    private Integer status;


    @Schema(description="状态：1：待处理  2：申诉中  3：已处理  4：已撤回")
    private String statusMsg;

    public String getStatusMsg(){
        return CarrierExceptionReportEnum.Status.getMsgByCode(status);
    }
    
    @Schema(description="扣罚金额")
    @MoneyOutConvert
    private BigDecimal deductionAmount;

    
    @Schema(description="异常上报时间")
    private String reportTime;

    @Schema(description="异常描述")
    private String reason;

    
    @Schema(description="处理人用户编码")
    private Long dealUserCode;

    
    @Schema(description="处理人用户姓名")
    private String dealUser;

    
    @Schema(description="处理时间")
    private String dealTime;

    
    @Schema(description="处理结果 1:承运违约 2:承运不违约 ")
    private Integer dealResult;

    @Schema(description="处理结果 1:承运违约 2:承运不违约")
    private String dealResultMsg;


    @Schema(description="处理结果")
    public String getDealResultMsg(){
        return ExceptionReportEnum.DealResult.getNameByCode(dealResult);
    }

    
    @Schema(description="是否转司机违约  1:是")
    private Integer transferDriverBreakContract;

    @Schema(description="是否转司机违约  1:是")
    private String transferDriverBreakContractMsg;


    public String getTransferDriverBreakContractMsg(){
        if(Objects.nonNull(transferDriverBreakContract)){
            return "是";
        }else{
            return "-";
        }
    }

    @Schema(description="创建时间")
    private String  createTime;


    @Schema(description="异常记录图片")
    private List<String> pictureUrlList;

    @Schema(description="异常记录视频")
    private List<String> videoUrlList;




    @Schema(description="处理方式  1:同意扣罚  2：申诉")
    private Integer dealWay;

    @Schema(description="申诉时间")
    private String appealTime;

    @Schema(description="申诉人")
    private String createName;

    @Schema(description="申诉原因")
    private String appealReason;


    @Schema(description="申诉图片")
    private List<String> appealPictureUrlList;

    @Schema(description="申诉视频")
    private List<String> appealVideoUrlList;




    @Schema(description="操作日志列表")
    private List<OrderChildExceptionReportOperationLogVO> operationLogs;





}
