package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Schema(description = "提现审批")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerCaseOutApproveParam {

    @Schema(description = "id", example = "1")
    private Integer id;

    @Schema(description = "平台付款银行")
    private String platformPaymentBank;

    @Schema(description = "平台付款银行账号")
    private String platformPaymentBankNumber;

    @Schema(description = "付款凭证", example = "a.png")
    private String paymentProof;

    @Schema(description = "平台付款金额", example = "11.21")
    @MoneyInConvert
    private BigDecimal platformPayBalance;

}
