package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectLineReportQualitySaveParam {

    @Schema(description = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;
    @Schema(description = "图片列表")
    private List<String> imageList;

    @Schema(description = "无法到达交货地原因", example = "车辆问题")
    @NotBlank(message = "无法到达交货地原因不能为空")
    private String remark;

}
