package com.clx.performance.param.app.collect;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CarrierDriverCollectTransportIntentionParam extends PageParam {

    @Schema(description = "id", example = "123")
    private Integer id;

    @Schema(description="排序编号")
    private Integer sortNo;

    @Schema(description="问题名称")
    @Size(max = 10, message = "问题名称长度不能超过10")
    private String collectName;

    @Size(max = 20, message = "问题描述长度不能超过20")
    @Schema(description="问题描述")
    private String collectDescribe;

    @Schema(description="状态：1单选 2多选")
    private Integer collectCheckType;

    @Schema(description="状态：1拉运意向 2拒绝拉运")
    private Integer collectType;

    @Schema(description="操作人编码")
    private Long createUserNo;

    @Schema(description="操作人")
    private String createUserName;

    @Schema(description="删除状态: 0-否;1-是")
    private Integer deleteStatus;

    @Schema(description="状态：1启用 2禁用")
    private Integer status;

    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Schema(description = "选项列表")
    private List<CarrierDriverCollectTransportIntentionRecordParam> collectIntentionRecordList;
}
