package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildSaveParam extends PositionParam {

    @Schema(description = "货单编号", example = "100000000")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

    @Schema(description = "车辆id", example = "1")
    @NotNull(message = "车辆id空")
    private Integer truckId;

    @Schema(description = "司机用户编号", example = "1")
    @NotNull(message = "司机用户编号空")
    private Long driverUserNo;

    @Schema(description = "支付方密码", example = "2356")
    private String pwd;

}
