package com.clx.performance.enums.vehiclewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum VehicleWarnConfigEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum WarnType {
        ARRIVE_SEND_DELAY(1, "运单-到达货源地延误"),
        GOTO_SEND_TIMEOUT(2, "运单-前往货源地超时"),
        ARRIVE_RECEIVE_DELAY(3, "运单-到达目的地延误"),
        GOTO_RECEIVE_TIMEOUT(4, "运单-前往目的地超时"),

        PARK_TIMEOUT(5, "运单-停留超时"),
        SENSITIVE_AREA_PARK_TIMEOUT(6, "运单-敏感区停留"),
        LOAD_TIMEOUT(7, "运单-装车超时"),
        UNLOAD_TIMEOUT(8, "运单-卸车超时"),
        DELAY(9, "运单-运单延误"),
        EXCEPTION_REPORT_DEAL(10, "异常上报处理"),
        ;

        private final Integer code;
        private final String msg;
        public static Optional<WarnType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(WarnType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum DeleteStatus {
        NO(0, "否"),
        YES(1, "是"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<DeleteStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(DeleteStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum Status {
        ENABLE(1, "启用"),
        DISABLE(2, "禁用"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum OrderWarnType {
        PENDING_QUOTATION(0, "订单待报价"),
        ACCEPTED(3, "订单已承接"),
        COMPLETED(9, "订单完成"),
        FINISHED(12, "订单完结"),
        CANCELED(4, "订单取消");

        private final Integer code;
        private final String msg;
        public static Optional<OrderWarnType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(OrderWarnType::getMsg).orElse(null);
        }
    }
}
