package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum SettlementWayEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum WayType {
        LOAD(1, "装车净重"),
        UNLOAD(2, "卸车净重"),
        UNLOAD_LOSS(3, "卸车净重（减货损）"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<WayType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(WayType::getMsg).orElse(null);
        }
    }



}
