package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsPendingVehicleUsageEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        PLATFORM_TRUCK(1, "平台车辆配货"),

        OWN_TRUCK(2, "自有车辆配货"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
    }


}
