package com.clx.performance.struct.export;

import com.clx.performance.model.export.ExportTemplate;
import com.clx.performance.param.pc.export.SaveExportTemplateParam;
import com.clx.performance.vo.pc.export.ExportFieldVo;
import com.clx.performance.vo.pc.export.ExportTemplateDetailVo;
import com.clx.performance.vo.pc.export.ExportTemplateVo;
import com.msl.common.utils.DateStructUtil;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class)
public interface ExportTemplateStruct {

    ExportTemplateVo convert(ExportTemplate template);

    List<ExportTemplateVo> convert(List<ExportTemplate> list);

    @Mapping(target = "fields", source = "fields")
    ExportTemplateDetailVo convert(ExportTemplate template, List<ExportFieldVo> fields);

    ExportTemplate convert(SaveExportTemplateParam param);
}
