package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectTraficCongestionParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam;
import com.clx.performance.vo.pc.collect.CollectTrafficCongestionVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectTrafficCongestionSqlProvider {

    public String pageTraffic(@Param("page") Page<CollectTrafficCongestionVO> page, @Param("param") PageCollectTraficCongestionParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, " +
                    " province, city, county, town, street, address, full_address, " +
                    " longitude, latitude, " +
                    " jam_time as jamTime, jam_image as jamImage, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " audit_status as auditStatus, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    "date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_traffic_congestion ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String carrierPageTraffic(@Param("page") Page<CollectTrafficCongestionVO> page, @Param("param") CarrierPageCollectTraficCongestionParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, " +
                    " province, city, county, town, street, address, full_address, " +
                    " longitude, latitude, " +
                    " jam_time as jamTime, jam_image as jamImage, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " audit_status as auditStatus, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    "date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_traffic_congestion ");
            if (StringUtils.isNotBlank(param.getAddress())) {WHERE("address like CONCAT(#{param.address},'%')");}

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            if (param.getAuditStatus() != null) {WHERE("audit_status = #{param.auditStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

}
