package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectLineReportParam;
import com.clx.performance.param.pc.carrier.*;
import com.clx.performance.vo.pc.collect.CollectLineReportVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectLineReportSqlProvider {

    public String pageLineReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") PageCollectLineReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageSendAddressReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectSendAddressReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");
            WHERE("report_type = 7");
            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT(#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}
            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no like CONCAT('%', #{param.truckNo}, '%')");}

            if (param.getReportStatus() != null) {WHERE("report_status = #{param.reportStatus}");}
            if (param.getAuditStatus() != null) {WHERE("audit_status = #{param.auditStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageAbnormalReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectAbnormalReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT(#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address like CONCAT(#{param.receiveAddress},'%')");}
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}
            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no like CONCAT('%', #{param.truckNo}, '%')");}

            if (param.getReportType() != null) {WHERE("report_type = #{param.reportType}");}
            else {
                WHERE("report_type in (1, 2, 3, 4)");
            }
            if (param.getAuditStatus() != null) {WHERE("audit_status = #{param.auditStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageNoTakeOrderReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectNoTakeOrderReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");
            WHERE("report_type = 6");

            if (StringUtils.isNotBlank(param.getOrderGoodsNo())) {WHERE("order_goods_no = #{param.orderGoodsNo}");}
            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT(#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address like CONCAT(#{param.receiveAddress},'%')");}
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

    public String carrierPageQualityReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectQualityReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");
            WHERE("report_type = 9");

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            if (param.getAuditStatus() != null) {WHERE("audit_status = #{param.auditStatus}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }
    public String carrierPageOtherReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectOtherReportParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, " +
                    " truck_no as truckNo, order_goods_no, child_no as childNo, address_id as addressId, address, " +
                    " send_address_id, send_address, receive_address_id, receive_address, " +
                    " type, report_type as reportType, report_status as reportStatus, remark, image, audit_status, " +
                    " date_format(report_time, '%Y-%m-%d %H:%i:%s') as reportTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_line_report ");
            WHERE("report_type = 8");

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("report_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("report_time <= #{param.endTime}");}

            ORDER_BY("report_time desc");
        }}.toString();
    }

}
