package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-10-26
 * Time 11:27
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrderGoodsLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_goods_no")
    @Schema(description="货单编码")
    private String orderGoodsNo;

    @TableField("create_by")
    @Schema(description="操作人ID")
    private Long createBy;

    @TableField("create_name")
    @Schema(description="操作人名称")
    private String createName;

    @TableField("type")
    @Schema(description="操作类型")
    private String type;

    @TableField("remark")
    @Schema(description="备注")
    private String remark;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
