package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods")
public class OrderGoods implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @Schema(description="订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    @TableField("truck_demand")
    private Integer truckDemand;

    @Schema(description="用车方式 1：平台车辆配货 2：自有车辆配货")
    @TableField("vehicle_usage")
    private Integer vehicleUsage;

    @TableField("order_goods_status")
    @Schema(description="货单状态")
    private Integer orderGoodsStatus;

    @TableField("loss_price")
    @Schema(description="损耗单价(分)")
    private BigDecimal lossPrice;

    @TableField("extract_weight")
    @Schema(description="提取吨数")
    private BigDecimal extractWeight;

    @TableField("residue_transport_weight")
    @Schema(description="剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @TableField("already_transport_weight")
    @Schema(description="已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @TableField("already_load_weight")
    @Schema(description="已装车吨数")
    private BigDecimal alreadyLoadWeight;

    @TableField("send_address_id")
    @Schema(description="发货地址ID")
    private Integer sendAddressId;

    @TableField("send_address_shorter")
    @Schema(description="发货地址简称")
    private String sendAddressShorter;

    @TableField("send_system_address_id")
    @Schema(description="发货标准地址ID")
    private Integer sendSystemAddressId;

    @TableField("send_longitude")
    @Schema(description="发货地址经度")
    private BigDecimal sendLongitude;

    @TableField("send_latitude")
    @Schema(description="发货地址纬度")
    private BigDecimal sendLatitude;

    @TableField("receive_address_id")
    @Schema(description="收货地址ID")
    private Integer receiveAddressId;

    @TableField("receive_address_shorter")
    @Schema(description="收货地址简称")
    private String receiveAddressShorter;

    @TableField("receive_system_address_id")
    @Schema(description="收货标准地址ID")
    private Integer receiveSystemAddressId;

    @TableField("receive_longitude")
    @Schema(description="收货地址经度")
    private BigDecimal receiveLongitude;

    @TableField("receive_latitude")
    @Schema(description="收货地址纬度")
    private BigDecimal receiveLatitude;

    @TableField("goods_id")
    @Schema(description="货物ID")
    private Integer goodsId;

    @TableField("goods_name")
    @Schema(description="货物名称")
    private String goodsName;

    @TableField("pending_order_way")
    @Schema(description="挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @TableField("directional_expire_time")
    @Schema(description="定向运单失效时间")
    private LocalDateTime directionalExpireTime;


    @TableField("last_order_time")
    @Schema(description="'最晚接单时间'")
    private LocalDateTime lastOrderTime;


    @TableField("last_arrive_send_time")
    @Schema(description="最晚到达货源地时间")
    private LocalDateTime lastArriveSendTime;


    @TableField("last_load_time")
    @Schema(description="最晚装货时间")
    private LocalDateTime lastLoadTime;


    @TableField("last_arrive_receive_time")
    @Schema(description="'最晚到达目的地时间'")
    private LocalDateTime lastArriveReceiveTime;




    @TableField("pending_order_time")
    @Schema(description="挂单时间")
    private LocalDateTime pendingOrderTime;

    @TableField("extract_way")
    @Schema(description="提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @TableField("need_truck_num")
    @Schema(description="需要车辆/辆")
    private Integer needTruckNum;

    @TableField("senior_logistics_manager_id")
    @Schema(description="高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @TableField("senior_logistics_manager_name")
    @Schema(description="高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @TableField("pending_order_freight")
    @Schema(description="挂单运费")
    private BigDecimal pendingOrderFreight;

    private BigDecimal forecastOrderFreight;        //预估运费单价（分）

    @TableField("user_no")
    @Schema(description="创建人用户编号")
    private Long userNo;

    @TableField("user_name")
    @Schema(description="创建人姓名")
    private String userName;

    @TableField("settlement_account_period")
    @Schema(description="结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;

    @TableField("settlement_way")
    @Schema(description="结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @TableField("stop_flag")
    @Schema(description="是否暂停 0：否   1：是")
    private Integer stopFlag;

    @TableField("batch_number")
    @Schema(description="批次号")
    private Long batchNumber;

    @Schema(description="平台运费报价税类型：0未税 1含税")
    private Integer platformFreightQuotationTaxType;
    @Schema(description="开票服务率%")
    private BigDecimal invoiceServiceFeeRate;

    @TableField("platform_service_fee_rate")
    @Schema(description="平台服务费费率%")
    private BigDecimal platformServiceFeeRate;
    @TableField("deposit")
    @Schema(description="接单保证金（分/车）")
    private BigDecimal deposit;

    @Schema(description="是否支持借款：0:否 1:是")
    private Integer supportLoan;

    private Integer orderSource;            //订单来源

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
