package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChild implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private Long ownerUserNo;                       //货主用户编号
    private String ownerName;                       //货主名称
    private String childNo;                         //运单编号
    private String orderGoodsNo;                    //货单编号
    private String orderNo;                         //订单编号

    private Integer goodsId;                        //货物id
    private String goodsName;                       //货物名称
    private BigDecimal freightPrice;                //运费单价（分）
    private BigDecimal forecastFreightPrice;        //预估运费单价（分）
    private BigDecimal lossPrice;                   //损耗单价(分)
    private BigDecimal orderFreightPrice;           //订单运费单价（分）

    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer sendSystemAddressId;            //发货标准地址id
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer receiveSystemAddressId;         //收货标准地址id
    private LocalDateTime loadDeadline;             //最晚装货时间

    private Long truckOwnUserNo;                    //车主编号
    private String truckOwnName;                    //车主姓名
    private Integer truckId;                        //车辆ID
    private String truckNo;                         //车牌号
    private BigDecimal truckLoad;                   //载重（单位吨）
    private String truckModel;                      //车型

    private Long driverUserNo;                      //司机用户编号
    private String driverName;                      //司机姓名
    private String driverMobile;                    //司机手机号

    private BigDecimal loadRough;                   //装货毛重（单位吨）
    private BigDecimal loadTare;                    //装货皮重（单位吨）
    private BigDecimal loadNet;                     //装货净重（单位吨）
    private BigDecimal unloadRough;                 //卸货毛重（单位吨）
    private BigDecimal unloadTare;                  //卸货皮重（单位吨）
    private BigDecimal unloadNet;                   //卸货净重（单位吨）
    private String unloadPoundNo;                   //卸货磅单编号

    private BigDecimal weight;                      //拉运重量（单位吨）
    private BigDecimal freight;                     //运费（分）

    private String cancelRemark;                    //取消原因
    private Integer cancelType;                     //司机取消原因类型
    private String cancelDetail;                   //司机取消详细原因
    private Integer poundStatus;                    //磅单审核状态  0 待审核 1 审核通过 2 审核驳回
    private Integer status;                         //状态

    private LocalDateTime payTime;                         //支付时间(抢单时间)
    private LocalDateTime arriveSendTime;                  //到达货源地时间
    private LocalDateTime firstLoadTime;                  //装货时间
    private LocalDateTime loadTime;                        //装车时间
    private LocalDateTime arriveReceiveTime;               //到达目的地时间
    private LocalDateTime firstUnloadTime;                  //交货时间
    private LocalDateTime unloadTime;                      //卸车时间
    private LocalDateTime confirmTime;                     //司机确认交货时间
    private LocalDateTime settleTime;                      //结算时间
    private LocalDateTime cancelTime;                      //取消时间
    private LocalDateTime finishTime;                      //完成时间

    private LocalDateTime expectSendTime;                      //预计到达货源地时间
    private LocalDateTime expectReceiveTime;                      //预计到达目的地时间

    private Integer settlementAccountPeriod;                 //结算账期  1拉运完成结  2月结

    private Integer settlementWay;                          //结算方式  1装车净重 2卸车净重 3卸车净重（减货损）
    private Integer invoicingCompanyId;  //开票公司id
    private String invoicingCompanyShorterName; //开票公司简称
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    private Integer reportFlag;  //是否上报 0-否;1-是

    private BigDecimal platformServiceFee;                  //平台服务费（分）
    private BigDecimal platformServiceFeeRate;              //平台服务费费率%
    private BigDecimal deposit;                             //接单保证金（分/车）
    private LocalDateTime poundAuditTime;                      //磅单审核通过时间

    /**
     * 驶入驶离货源地状态 0 初始 1 驶入 2 驶离
     */
    private Integer enterExitSendStatus;
    /**
     * 驶离通知状态 0 未通知 1 已通知
     */
    private Integer exitNoticeStatus;
    /**
     * 是否解除监装限制 0 未解除 1 解除
     */
    private Integer removeLoadLimitStatus;

    private Integer orderSource;            //订单来源

    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}
