package com.clx.performance.listener;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.clx.open.sdk.callback.message.OrderInfoMessage;
import com.clx.order.enums.OrderEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.config.ConfiguredOpenProperties;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.vehiclewarn.VehicleWarnUserDao;
import com.clx.performance.model.vehiclewarn.VehicleWarnUser;
import com.clx.performance.param.mq.SendSmsNoticeParam;
import com.msl.common.open.ConfiguredOpenClient;
import com.msl.common.result.Result;
import com.msl.message.sdk.action.MessageAction;
import com.msl.message.sms.api.sms.SmsMessage;
import com.msl.message.sms.api.sms.content.SmsMessageContentImpl;
import com.msl.message.sms.api.sms.recipient.SmsMessageRecipientImpl;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.clx.performance.enums.OrderEnum.Status.*;
import static com.msl.message.sms.api.enums.RecipientTypeEnum.USER_MOBILE;

@Slf4j
@Component
@AllArgsConstructor
public class SendSmsListener {

    private final ConfiguredOpenClient configuredOpenClient;
    private final ConfiguredOpenProperties properties;


    @RabbitListener(queues = RabbitKeyConstants.NOTICE_SEND_SMS_QUEUE)
    public void onMessage(Message message) {
        try{
            log.info("监听到通用发送通知短信,消息内容{}", new String(message.getBody()));
            SendSmsNoticeParam messageParam = JSONUtil.toBean(new String(message.getBody()),
                    new TypeReference<MqWrapper<SendSmsNoticeParam>>() {
                    },false).getData();

            log.info("发送短信的手机号列表:{}",messageParam.getMobileList());
            if(CollectionUtils.isEmpty(messageParam.getMobileList())){
                return;
            }

            SmsMessage smsMessage = new SmsMessage();

            //设置消息内容
            SmsMessageContentImpl smsMessageContent= new SmsMessageContentImpl();


            //模版code
            smsMessageContent.setCode(messageParam.getCode());


            smsMessageContent.setParams(messageParam.getParams());


            //设置消息接收人
            SmsMessageRecipientImpl smsMessageRecipient = new SmsMessageRecipientImpl();
            smsMessageRecipient.setUserType(USER_MOBILE.getCode());
            smsMessageRecipient.setTargets(String.join(",", messageParam.getMobileList()));


            smsMessage.setContent(smsMessageContent);
            smsMessage.setRecipient(smsMessageRecipient);

            //从消息中心注册获取的通道key
            smsMessage.setAccessKey(properties.getAccessKey());


            //向消息中心发送消息
            log.info("开始发送消息中心短信，请求参数：{}", JSON.toJSONString(smsMessage));
            Result<Object> result = configuredOpenClient.doAction(new MessageAction(smsMessage));
            if(result.succeed()){
                log.info("结束发送消息中心短信成功，响应结果：{}", JSON.toJSONString(result));
            }else{
                log.error("结束发送消息中心短信失败，响应结果：{}", JSON.toJSONString(result));
            }
        }catch (Exception e){
            log.info("监听发送通知短信发生异常，异常原因：{}", ExceptionUtils.getStackTrace(e));
        }
    }




}
